% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_markerpos.R
\name{find_markerpos}
\alias{find_markerpos}
\title{Find positions of markers}
\usage{
find_markerpos(cross, markers, na.rm = TRUE)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.
Can also be a map (as a list of vectors of marker positions).}

\item{markers}{A vector of marker names.}

\item{na.rm}{If TRUE, don't include not-found markers in the
results (but issue a warning if some markers weren't found). If
FALSE, include those markers with \code{NA} for chr and position.}
}
\value{
A data frame with chromosome and genetic and physical
positions (in columns \code{"gmap"} and \code{"pmap"}), with markers as
row names. If the input \code{cross} is not a cross2 object but
rather a map, the output contains \code{chr} and \code{pos}.
}
\description{
Find positions of markers within a cross object
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# find markers
find_markerpos(iron, c("D8Mit294", "D11Mit101"))
}
\seealso{
\code{\link[=find_marker]{find_marker()}}
}
