% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_xo.R
\name{locate_xo}
\alias{locate_xo}
\title{Locate crossovers}
\usage{
locate_xo(geno, map, quiet = TRUE, cores = 1)
}
\arguments{
\item{geno}{List of matrices of genotypes (output of \code{\link[=maxmarg]{maxmarg()}} or \code{\link[=viterbi]{viterbi()}}).}

\item{map}{List of vectors with the map positions of the markers.}

\item{quiet}{If FALSE, print progress messages.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
A list of lists of estimated crossover locations, with
crossovers placed at the midpoint of the intervals that contain
them.
}
\description{
Estimate the locations of crossovers in each individual on each chromosome.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
map <- insert_pseudomarkers(iron$gmap, step=1)
pr <- calc_genoprob(iron, map, error_prob=0.002, map_function="c-f")
g <- maxmarg(pr)
pos <- locate_xo(g, iron$gmap)

}
\seealso{
\code{\link[=count_xo]{count_xo()}}
}
