skip_on_cran()
skip_on_ci()

test_that("fetch_distributions returns a tbl_df with expected column names and types", {
  local_mocked_bindings(
    glue_api_v3 = function(base_url)
      "https://stoplight.io/mocks/qualtricsv2/publicapidocs/60919"
  )

  x <- fetch_distributions("SV_abcdef123456789")
  expect_s3_class(x, c("tbl_df", "tbl", "data.frame"))
  expect_s3_class(x$sendDate, c("POSIXct", "POSIXt"))
  expect_s3_class(x$createdDate, c("POSIXct", "POSIXt"))
  expect_s3_class(x$modifiedDate, c("POSIXct", "POSIXt"))

  expect_type(x$id, "character")
  expect_type(x$parentDistributionId, "character")
  expect_type(x$ownerId, "character")
  expect_type(x$organizationId, "character")
  expect_type(x$requestStatus, "character")
  expect_type(x$requestType, "character")
  expect_type(x$customHeaders, "character")
  expect_type(x$headers_fromEmail, "character")
  expect_type(x$headers_replyToEmail, "character")
  expect_type(x$headers_fromName, "character")
  expect_type(x$subjectMessage_messageId, "character")
  expect_type(x$subjectMessage_libraryId, "character")
  expect_type(x$recipients_mailingListId, "character")
  expect_type(x$recipients_contactId, "character")
  expect_type(x$recipients_libraryId, "character")
  expect_type(x$recipients_sampleId, "character")
  expect_type(x$message_libraryId, "character")
  expect_type(x$message_messageId, "character")
  expect_type(x$message_messageType, "character")
  expect_type(x$surveyLink_surveyId, "character")
  expect_type(x$surveyLink_expirationDate, "character")
  expect_type(x$surveyLink_linkType, "character")
  expect_type(x$stats_sent, "integer")
  expect_type(x$stats_failed, "integer")
  expect_type(x$stats_started, "integer")
  expect_type(x$stats_bounced, "integer")
  expect_type(x$stats_opened, "integer")
  expect_type(x$stats_skipped, "integer")
  expect_type(x$stats_finished, "integer")
  expect_type(x$stats_complaints, "integer")
  expect_type(x$stats_blocked, "integer")
})
