% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plop.R
\name{plop}
\alias{plop}
\title{Profit & Loss operator function}
\usage{
plop(x, wts = NULL, approxim = c(0, 1))
}
\arguments{
\item{x}{a numeric matrix of asset returns or losses}

\item{wts}{a numeric vector or matrix containing the portfolio
weights; portfolio value is standardized to 1 on any observation unit;
sum of weights should not exceed 1 (row-wise for matrices); by default
the portfolio is equally weighted over time and across all assets; if a
vector is passed to \code{wts} the portfolio is equally weighted over time}

\item{approxim}{controls if a first-order approximation for the calculation
of returns or losses is used; default is \code{1} (first-order
approximation is employed)}
}
\value{
Returns a list with the following elements:
\describe{
\item{pl}{Weighted portfolio returns or losses}
\item{wts}{Portfolio weights}
}
}
\description{
Calculates portfolio returns or losses by assigning weights
}
\examples{
# creating portfolio
portfol <- cbind(SP500$price_close, DJI$price_close)
returns <- apply(portfol, 2, function(x) diff(log(x)))
# defining weights and applying the P&L operator function
wts <- c(0.4, 0.6)
portret <- plop(returns, wts = wts, approxim = 1)
portloss <- plop(-returns, wts = wts, approxim = 1)
plot.ts(cbind(portret$pl, portloss$pl))

}
