% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb.R
\name{nb_model}
\alias{nb_model}
\title{Train a Naive Bayes Model}
\usage{
nb_model(train_vectorized, Y, test_vectorized, parallel = FALSE, tune = FALSE)
}
\arguments{
\item{train_vectorized}{The training feature matrix (e.g., a `dfm` from quanteda).
This should be a sparse matrix.}

\item{Y}{The response variable for the training set. Should be a factor for
classification.}

\item{test_vectorized}{The test feature matrix, which must have the same
features as `train_vectorized`}

\item{parallel}{Logical}

\item{tune}{Logical. If TRUE, tests different Laplace smoothing values.}
}
\description{
Train a Naive Bayes Model
}
\examples{
#Create dummy vectorized data
train_matrix <- matrix(runif(100), nrow = 10)
test_matrix <- matrix(runif(50), nrow = 5)
colnames(train_matrix) <- paste0("word", 1:10)
colnames(test_matrix) <- paste0("word", 1:10)
y_train <- factor(sample(c("P", "N"), 10, replace = TRUE))
# Run model
model_results <- nb_model(train_matrix, y_train, test_matrix)
print(model_results$pred)
}
