% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_count.R
\name{join_count}
\alias{join_count}
\title{Test for Spatial Join Count Statistics}
\usage{
join_count(matrix_data, verbose = TRUE)
}
\arguments{
\item{matrix_data}{A binary matrix (with elements 0 and 1) representing the spatial distribution
of two types of points: 0 for healthy plants (H) and 1 for diseased plants (D). This matrix reflects
the geographical distribution or layout of plants in the studied area.}

\item{verbose}{Logical. If TRUE (default), prints a formatted message to the console.}
}
\value{
A comprehensive, rich-text formatted string of results that includes:
\itemize{
\item Statistical counts of specific binary sequences (e.g., "01 or 10", "11")
\item Expected counts under the assumption of Complete Spatial Randomness (CSR)
\item Standard deviations and Z-scores (ZHD for "01 or 10" sequences, ZDD for "11" sequences)
\item Interpretation of whether the spatial distribution for each sequence type is
"Aggregated" or "Not Aggregated" based on Z-scores
\item A summary explaining the implications of these statistics and patterns
}
The return value aims to provide a clear understanding of the spatial arrangement's
characteristics, aiding in further spatial analysis or research.
}
\description{
The function \code{join_count} calculates spatial join count statistics for a binary matrix,
identifying patterns of aggregation or randomness.
}
\details{
The function conducts an analysis by first counting the occurrence of specific sequences
("01 or 10" and "11" - equivalent to HD and DD) in the binary matrix.
It then calculates expected values, standard
deviations, and Z-scores to determine the spatial randomness or aggregation. The analysis
considers both horizontal and vertical adjacency (rook case) in the matrix.
}
\references{
Madden, L. V., Hughes, G., & van den Bosch, F. (2007). The Study of Plant Disease Epidemics.
The American Phytopathological Society.
}
\seealso{
Other Spatial analysis: 
\code{\link{AFSD}()},
\code{\link{BPL}()},
\code{\link{count_subareas}()},
\code{\link{count_subareas_random}()},
\code{\link{fit_gradients}()},
\code{\link{oruns_test}()},
\code{\link{oruns_test_boustrophedon}()},
\code{\link{oruns_test_byrowcol}()},
\code{\link{plot_AFSD}()}
}
\concept{Spatial analysis}
