% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_schema.R
\name{bind_evidence}
\alias{bind_evidence}
\title{Bind Evidence Tables}
\usage{
bind_evidence(...)
}
\arguments{
\item{...}{Evidence data.frames to bind.}
}
\value{
A single combined evidence data.frame.
}
\description{
Row-binds multiple evidence data.frames after validating each one.
}
\examples{
ctx <- suppressMessages(r4sub_run_context("STUDY1", "DEV"))
make_ev <- function(ind_id) {
  suppressMessages(as_evidence(
    data.frame(
      asset_type = "validation", asset_id = "ADSL",
      source_name = "pinnacle21", indicator_id = ind_id,
      indicator_name = ind_id, indicator_domain = "quality",
      severity = "low", result = "pass",
      stringsAsFactors = FALSE
    ),
    ctx = ctx
  ))
}
ev1 <- make_ev("IND-001")
ev2 <- make_ev("IND-002")
combined <- suppressMessages(bind_evidence(ev1, ev2))
nrow(combined)

}
