% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{regulatory_indicators}
\alias{regulatory_indicators}
\title{Regulatory Indicator Definitions}
\format{
A tibble with 30 rows and 7 columns:
\describe{
\item{indicator_id}{Character. Unique indicator identifier.}
\item{indicator_name}{Character. Human-readable indicator name.}
\item{domain}{Character. Indicator domain: quality, trace, risk, usability.}
\item{description}{Character. Detailed description.}
\item{severity_default}{Character. Default severity level.}
\item{source}{Character. Typical source tool.}
\item{tags}{Character. Comma-separated tags.}
}
}
\source{
Curated indicator definitions for the R4SUB (R for Regulatory
Submission) ecosystem.
}
\usage{
regulatory_indicators
}
\description{
Reference table of 30 indicator definitions across all four R4SUB
(R for Regulatory Submission) domains (quality, trace, risk, usability).
Each indicator has a unique ID, default severity, typical source, and
descriptive tags.
}
\examples{
data(regulatory_indicators)
table(regulatory_indicators$domain)
}
\keyword{datasets}
