% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{trace_mapping}
\alias{trace_mapping}
\title{ADaM-to-SDTM Traceability Mapping}
\format{
A tibble with 25 rows and 6 columns:
\describe{
\item{adam_dataset}{Character. Source ADaM dataset.}
\item{adam_var}{Character. Source ADaM variable.}
\item{sdtm_domain}{Character. Target SDTM domain (NA if derived).}
\item{sdtm_var}{Character. Target SDTM variable (NA if derived).}
\item{derivation_text}{Character. Derivation description text.}
\item{confidence}{Numeric. Mapping confidence score (0-1, NA if unmapped).}
}
}
\source{
Synthetic traceability mapping based on CDISC conventions.
}
\usage{
trace_mapping
}
\description{
Maps ADaM (Analysis Data Model) variables to their SDTM (Study Data
Tabulation Model) source variables with derivation text and confidence
scores. Includes direct copies, derived variables, and unmapped entries.
Follows CDISC (Clinical Data Interchange Standards Consortium)
traceability conventions.
}
\examples{
data(trace_mapping)
table(trace_mapping$adam_dataset)
}
\keyword{datasets}
