% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_recruitment.R
\name{genRecruits}
\alias{genRecruits}
\title{Generate a vector of recruitment abundance for the dynamic pool model.}
\usage{
genRecruits(
  method = c("fixed", "uniform", "normal", "StrYC_Nth", "StrYC_randInt"),
  simyears = 50,
  Nrec = NULL,
  MinR = NULL,
  MaxR = NULL,
  meanR = NULL,
  sdR = NULL,
  Nthyr = NULL,
  sizeStr = NULL,
  avgFreq = NULL
)
}
\arguments{
\item{method}{A single string to call the method of generating a vector of recruits. \code{fixed} generate recruitment based on a fixed value for each year of simyears, \code{uniform} generates recruitment based on random values from a unifrom distribution for each year of simyears, \code{normal} generates recruitment based on random values from a unifrom distribution for each year of simyears, \code{StrYC_Nth} generates recruitment based on a strong year class every Nth year, and \code{StrYC_randInt} generates recruitment based on a strong year classes at random intervals.}

\item{simyears}{A single numeric that sets the number of years to simulate recruitment}

\item{Nrec}{A single numeric that sets the fixed number of recruitment}

\item{MinR}{A single numeric that sets the minimum recruitment abundance during simulations.}

\item{MaxR}{A single numeric that sets the maximum recruitment abundance during simulations.}

\item{meanR}{A single numeric that sets the mean recruitment abundance.}

\item{sdR}{A single numeric that sets the standard deviation of recruitment abundance}

\item{Nthyr}{A single numeric that sets the Nth year that a strong year class will occur}

\item{sizeStr}{A single numeric that sets the multiplier for the strong year class relative to meanR}

\item{avgFreq}{A single numeric that sets the average frequency of a strong year class.}
}
\value{
A vector that contains the given recruitment options that can be used directly in the dynamic pool model (e.g., \code{\link{dpmBH}}).
}
\description{
These function is used to generate recruitment abundances across multiple years using different random function.
}
\details{
This function is used internally and not generally used interactively
}
\examples{
# To be filled out later

}
\author{
Jason C. Doll, \email{jason.doll@fmarion.edu}
}
