% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSDI.R
\name{calcSDI}
\alias{calcSDI}
\title{Calculate Shoreline Development Index}
\usage{
calcSDI(DEM, units = "m", by = 1, stop = NULL)
}
\arguments{
\item{DEM}{SpatRaster object of a given waterbody, rasters can be transformed to SpatRaster via the rast() function in 'terra'}

\item{units}{character describing units of raster coordinate system. Can be meters, kilometers, or hectares ("m", "km", "ha"), default = "m"}

\item{by}{numeric increment per unit depth by which areas are calculated. Higher values will result in lower resolution. Default = 1}

\item{stop}{optional numeric value specifying depth at which to stop calculations, default = NULL}
}
\value{
data frame of perimeter lengths and SDI values for given depths
}
\description{
Calculates Shoreline Development Index value across water levels for a given waterbody.
}
\examples{
#load raster
DEM <- terra::rast(system.file("extdata", "example_raster.tif", package = 'rLakeHabitat'))
#run function
calcSDI(DEM, units = 'm')
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
