% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_plot1.R
\name{bar_plot1}
\alias{bar_plot1}
\title{The first barplot of the ranks of genotypes}
\usage{
bar_plot1(datap, lowt = FALSE)
}
\arguments{
\item{datap}{The data set}

\item{lowt}{A parameter indicating whether lower rates of the trait
is preferred or not. For grain yield e.g. Upper values is preferred. For plant height
lower values e.g. is preferred.}
}
\value{
Returns an object of class \verb{gg, ggmatrix}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
\itemize{
\item \code{bar_plot1()} creates a bar plot for the new index (rYWAASB
for individuals) for simultaneous selection of genotypes by
trait and WAASB index using ggplot2.
}
}
\examples{
# Case 1:  Higher trait values are preferred. For instance grain yield
# in cereals is a trait which its higher values are preferred and ranking
# is performed from the higher to lower values i.e. 1st, 2nd, 3rd etc
# in maize dataset.
\donttest{
data(maize)
bar_plot1(maize) # or: bar_plot1(maize, lowt = FALSE)
}
# Case 2:  In this case, the lower values of the given trait are preferred.
# For instance days to maturity (dm) and plant height are traits where their
# lower values are preferred.
\donttest{
data(dm)
bar_plot1(dm, lowt = TRUE)
}
}
\references{
H. Wickham. ggplot2: Elegant Graphics for Data Analysis.
Springer-Verlag New York, 2016.
}
\author{
{
Ali Arminian \href{mailto:abeyran@gmail.com}{abeyran@gmail.com}
}
}
