% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.sim_results.R
\name{summary.sim_results}
\alias{summary.sim_results}
\title{Summary Of \code{sim_results} Object}
\usage{
\method{summary}{sim_results}(object, ...)
}
\arguments{
\item{object}{\code{sim_results} object; returned by \code{\link{sim}} function}

\item{...}{further arguments passed to or from other methods; none specified}
}
\value{
\code{summary.sim_results} object
}
\description{
Summary Of \code{sim_results} Object
}
\examples{

# data preparation
library(terra)

n1_small <- rast(system.file("input_maps/n1_small.tif", package = "rangr"))
K_small <- rast(system.file("input_maps/K_small.tif", package = "rangr"))

sim_data <- initialise(
  n1_map = n1_small,
  K_map = K_small,
  r = log(2),
  rate = 1 / 1e3
)

# simulation
sim_results <- sim(sim_data, time = 10)
summary(sim_results)

}
