% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girsanov_logratio.r
\name{girsanov_logratio}
\alias{girsanov_logratio}
\title{Girsanov Log-Ratio for Drift-Tilted Diffusions}
\usage{
girsanov_logratio(theta_path, Winc, dt)
}
\arguments{
\item{theta_path}{Numeric vector of drift tilts \eqn{\theta_t}.}

\item{Winc}{Numeric vector of Brownian increments \eqn{\Delta W_t}.}

\item{dt}{Time step size.}
}
\value{
A numeric log-likelihood ratio.
}
\description{
Computes the Radon-Nikodym derivative (log form) associated with a
Girsanov change of measure for an SDE:
}
\details{
\eqn{dX_t = b(X_t)\, dt + dW_t}

tilted by an alternative drift:

\eqn{dX_t = (b(X_t) + \theta_t)\, dt + dW_t}.

The log-likelihood ratio is:

\deqn{
  \log \frac{dQ}{dP}
    = \sum_t \left( \theta_t W_t - \frac{1}{2}\theta_t^2\, dt \right)
}

This function returns the log-ratio for a given path of drift tilts
\code{theta_path}, Brownian increments \code{Winc}, and time step \code{dt}.
}
