% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph_size.R
\name{coxph_size}
\alias{coxph_size}
\title{Sample Size or Power for Cox Proportional Hazards}
\usage{
coxph_size(
  hr,
  hr0 = NULL,
  delta = NULL,
  pE,
  pA,
  alpha,
  beta = NULL,
  n = NULL,
  test_type = "2-side"
)
}
\arguments{
\item{hr}{Numeric. True hazard ratio.}

\item{hr0}{Numeric (optional). Null hypothesis hazard ratio. Required for \code{"2-side"}, \code{"non-inferiority"} test.}

\item{delta}{Numeric (optional). Margin for \code{"equivalence test"}. Required for \code{"equivalence"} test.}

\item{pE}{Numeric. Overall event probability.}

\item{pA}{Numeric. Proportion of group A.}

\item{alpha}{Numeric. Type I error rate.}

\item{beta}{Numeric (optional). Type II error rate. Required for sample size calculation.}

\item{n}{Integer (optional). Sample size. Required for power calculation.}

\item{test_type}{Character. \code{"2-side"}, \code{"non-inferiority"}, or \code{"equivalence"}. Default is \code{"2-side"}.}
}
\value{
Numeric. Returns sample size (if \code{beta} is given), or power (if \code{n} is given).
}
\description{
Calculates sample size or power for a cox proportional hazards model.
}
\note{
Only one of \code{beta} (for sample size calculation) or \code{n} (for power calculation) should be specified.

Required arguments by \code{test_type}:
\itemize{
\item \code{"2-side"}/\verb{"non-inferiority}:
\itemize{
\item For sample size: \code{hr}, \code{hr0}, \code{pE}, \code{pA}, \code{alpha}, \code{beta}
\item For power: \code{hr}, \code{hr0}, \code{pE}, \code{pA}, \code{alpha}, \code{n}
}
\item \code{"equivalence"}:
\itemize{
\item For sample size: \code{hr}, \code{delta}, \code{pE}, \code{pA}, \code{alpha}, \code{beta}
\item For power: \code{hr}, \code{delta}, \code{pE}, \code{pA}, \code{alpha}, \code{n}
}
}
}
\examples{
# Sample size for a `"2-side"` test
coxph_size(hr = 2, hr0 = 1, pE = 0.8, pA = 0.5,
           alpha = 0.05, beta = 0.2, test_type = "2-side")

# Power of `"2-side"` test
coxph_size(hr = 2, hr0 = 1, pE = 0.8, pA = 0.5,
           alpha = 0.05, n = 82, test_type = "2-side")

# Sample size for `"non-inferiority"` test
coxph_size(hr = 2, hr0 = 1, pE = 0.8, pA = 0.5,
           alpha = 0.025, beta = 0.2, test_type = "non-inferiority")

# Power of `"non-inferiority"` test
coxph_size(hr = 2, hr0 = 1, pE = 0.8, pA = 0.5,
           alpha = 0.025, n = 82, test_type = "non-inferiority")

# Sample size for `"equivalence"` test
coxph_size(hr = 1, delta = 0.5, pE = 0.8, pA = 0.5,
           alpha = 0.05, beta = 0.2, test_type = "equivalence")

# Power of `"equivalence"` test
coxph_size(hr = 1, delta = 0.5, pE = 0.8, pA = 0.5,
           alpha = 0.05, n = 172, test_type = "equivalence")

}
