% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_particles.R
\name{adapt_particles}
\alias{adapt_particles}
\title{Adapt the number of particles}
\usage{
adapt_particles(
  x,
  min = 1,
  max = 1024,
  target_variance = 1,
  quiet = FALSE,
  target.variance,
  ...
)
}
\arguments{
\item{x}{a [rbi::libbi()] object}

\item{min}{minimum number of particles}

\item{max}{maximum number of particles}

\item{target_variance}{target log-likelihood variance; once this is crossed,
the current number of particles will be used}

\item{quiet}{if set to TRUE, will not provide running output of particle
numbers tested}

\item{target.variance}{deprecated; use \code{target_variance} instead}

\item{...}{parameters for libbi$run}
}
\value{
a [rbi::libbi()] with the desired proposal distribution
}
\description{
This function takes the provided [rbi::libbi()] and runs
  MCMC at a single point (i.e., repeatedly proposing the same parameters),
  adapting the number of particles distribution until the variance of the
  log-likelihood crosses the value given as \code{target.variance} (1 by
  default).
}
\examples{
example_obs <- rbi::bi_read(system.file(package="rbi", "example_dataset.nc"))
example_model <- rbi::bi_model(system.file(package="rbi", "PZ.bi"))
example_bi <- rbi::libbi(model = example_model, obs = example_obs)
obs_states <- rbi::var_names(example_model, type = "obs")
max_time <- max(vapply(example_obs[obs_states], function(x) {
  max(x[["time"]])
}, 0))
\dontrun{
  adapted <- adapt_particles(example_bi, nsamples = 128, end_time = max_time)
}
}
