% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panther.R
\name{rba_panther_tree_grafter}
\alias{rba_panther_tree_grafter}
\title{PANTHER Tree Grafter}
\usage{
rba_panther_tree_grafter(protein_seq, target_organisms = NULL, ...)
}
\arguments{
\item{protein_seq}{A character string with the protein's sequence. Maximum
allowed sequence length is 50kb.}

\item{target_organisms}{(numeric) NCBI taxon ID(s) to filter the results.
run \code{\link{rba_panther_info}} with argument 'what = "organisms"' to
get a list of PANTHER's supported organisms.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing PANTHER tree topology information.
}
\description{
Use this function to retrieve a PANTHER family's tree topology information
  with a node corresponding to your sequence grafted in the best location
  in that tree.
}
\details{
For more information, see:
  Haiming Tang, Robert D Finn, Paul D Thomas, TreeGrafter: phylogenetic
  tree-based annotation of proteins with Gene Ontology terms and other
  annotations, Bioinformatics, Volume 35, Issue 3, February 2019, Pages
  518–520, \doi{10.1093/bioinformatics/bty625}
}
\section{Corresponding API Resources}{

 "GET https://www.pantherdb.org/services/oai/pantherdb/graftsequence"
}

\examples{
\donttest{
rba_panther_tree_grafter("MKVLWAALLVTFLAGCQAKVEQAVETE")
}

}
\references{
\itemize{
  \item Huaiyu Mi, Dustin Ebert, Anushya Muruganujan, Caitlin Mills,
  Laurent-Philippe Albou, Tremayne Mushayamaha, Paul D Thomas, PANTHER
  version 16: a revised family classification, tree-based classification
  tool, enhancer regions and extensive API, Nucleic Acids Research,
  Volume 49, Issue D1, 8 January 2021, Pages D394–D403,
  https://doi.org/10.1093/nar/gkaa1106
  \item \href{https://www.pantherdb.org/services/details.jsp}{PANTHER
  Services Details}
  \item
  \href{https://www.pantherdb.org/publications.jsp#HowToCitePANTHER}{Citations
  note on PANTHER website}
  }
}
\seealso{
Other "PANTHER": 
\code{\link{rba_panther_enrich}()},
\code{\link{rba_panther_family}()},
\code{\link{rba_panther_homolog}()},
\code{\link{rba_panther_info}()},
\code{\link{rba_panther_mapping}()},
\code{\link{rba_panther_ortholog}()}
}
\concept{"PANTHER"}
