% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_pathways_events}
\alias{rba_reactome_pathways_events}
\title{Get Events Contained in an Upstream Events}
\usage{
rba_reactome_pathways_events(event_id, attribute_name = NULL, ...)
}
\arguments{
\item{event_id}{Reactome event's database ID (DbId) or Stable ID (StId).}

\item{attribute_name}{An attribute of the events to be returned instead of
the whole events. see \href{https://reactome.org/content/schema/Event}{
Reactome Data Schema: Event} for available options.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
Data frame where each row is a contained event and columns are
  event's attributes. If an "attribute_name" argument was supplied, a
  character vector will be returned.
}
\description{
A Reactome Event could be comprised of other events (meaning, a pathway that
  include other pathways itself). Use this function to recursively return
  all the events which reside downstream of your supplied event ID (or
  an attribute of that events).
}
\details{
By Reactome's definition, Events are the building blocks of biological
  processes and could be of two main classes: "Pathway" or
  "Reaction-like events". The events are organized in a hierarchical
  structure; and each event could be child or parent to another event; The
  hierarchy will always begin with a "Top level pathway" event. Also note
  that a given event could be part of more that one hierarchies.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/pathway/\{id\}/
 containedEvents"
 \cr "GET https://reactome.org/ContentService/data/pathway/\{id\}/
 containedEvents/\{attributeName\}"
}

\examples{
\donttest{
rba_reactome_pathways_events(event_id = "R-HSA-5673001")
}
\donttest{
rba_reactome_pathways_events(event_id = "R-HSA-5673001",
    attribute_name = "displayName")
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
Other "Reactome Content Service - Pathway Related Queries": 
\code{\link{rba_reactome_pathways_low}()},
\code{\link{rba_reactome_pathways_top}()}
}
\concept{"Reactome Content Service - Pathway Related Queries"}
