% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{qCal}
\alias{qCal}
\title{Computes the quantile date of calibrated dates}
\usage{
qCal(x, p = 0.5)
}
\arguments{
\item{x}{A \code{CalDates} class object.}

\item{p}{A numeric value of probability. Default is 0.5 (median).}
}
\value{
A vector of quantile dates in cal BP
}
\description{
Function for generating a vector quantile calibrated dates from a \code{CalDates} class object.
}
\examples{
x <- calibrate(c(3050,2950),c(20,20))
qCal(x,p=0.2)
}
\seealso{
\code{\link[rcarbon]{calibrate}}, \code{\link[rcarbon]{barCodes}}
}
