% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_refundObj.matrix.R
\name{as_refundObj.matrix}
\alias{as_refundObj.matrix}
\title{Convert matrices to dataframes for use in functional data analyses}
\usage{
\method{as_refundObj}{matrix}(obj, index = NULL, ...)
}
\arguments{
\item{obj}{Matrix object to be converted; rows contain functional observations on subjects.}

\item{index}{Time grid on which functional data are observed; defaults to \code{NULL},
which assumes an equally-spaced grid on [0,1].}

\item{...}{additional arguments to be passed to methods (not used).}
}
\value{
An object of classes \code{data.frame} and \code{refund.object}, the latter of
which is so far not used. Columns are \code{id} (taken from the rownames of \code{obj},
if they exist), \code{index} (with behavior described above), and \code{value} (taken
from entries in \code{obj}).
}
\description{
Convert matrices to dataframes for use in functional data analyses
}
\examples{


library(ggplot2)
library(refund)

cca_df = as_refundObj(DTI$cca)
ggplot(cca_df, aes(x = index, y = value, group = id)) + geom_line()


}
\author{
Jeff Goldsmith \email{jeff.goldsmith@columbia.edu}
}
