% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproducibleR.R
\name{reproducibleR}
\alias{reproducibleR}
\title{Knitr Hook}
\usage{
reproducibleR(options)
}
\arguments{
\item{options}{A list of chunk options passed from the
knitr engine. Usually this is just the object options
passed to the engine function; see \link[knitr]{knit_engines}.}
}
\value{
A character string generated from the source code and output.
}
\description{
This is the main RMarkdown chunk hook for processing
the automated reproducibility tests of code chunks. This function is
not intended to be called directly. Rather, it is expected that
RStudio calls this function when rendering chunks with the label
identical to this function name.
}
\details{
This function first executes the R code from a given chunk.
If a variable is declared within the scope of the chunk,
meta information about the variable's content are generated. If no metadata exists,
this metadata is stored in a separate file. If metadata exists, it is compared
against the metadata of the reproduction attempt.
}
\examples{

reproducibleR(knitr::opts_chunk$merge(list(engine="reproducibleR",code="1+1")))

}
\author{
Andreas M. Brandmaier
}
