% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_settings.R
\name{add_settings}
\alias{add_settings}
\title{Add settings}
\usage{
add_settings(
  problem,
  precision = 4,
  time_limit = 0,
  nb_solutions = 1,
  optimality_gap = 0,
  solution_name_prefix = "Solution "
)
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}

\item{precision}{\code{integer} Precision for calculations.
Defaults to 4.}

\item{time_limit}{\code{integer} Maximum permitted run time for optimization
(seconds).
Defaults to 0.}

\item{nb_solutions}{\code{integer} Number of desired solutions. Defaults to 1.}

\item{optimality_gap}{\code{numeric} Optimality gap (between 0 and 1).
For example, an argument of 0.1 means that solutions should be within 10\%
of optimality.
Defaults to 0, such that optimal solutions are returned.}

\item{solution_name_prefix}{\code{character} Prefix for the name of solutions.
Defaults to "Solution "}
}
\value{
An updated restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object.
}
\description{
Add settings to a restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object
to customize the optimization procedure.
}
\examples{
\dontrun{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

# create problem
p <- restopt_problem(
    existing_habitat = habitat_data,
    aggregation_factor = 16,
    habitat_threshold = 0.7
  ) \%>\%
  add_settings(time_limit = 1, precision = 4, nb_solutions = 2)
# print problem
print(p)
}
}
