% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran-compliance.R
\name{cran}
\alias{cran}
\title{CRAN compliant extendr packages}
\description{
R packages developed using extendr are not immediately ready to
be published to CRAN. The extendr package template ensures that
CRAN publication is (farily) painless.
}
\section{CRAN requirements}{


In order to publish a Rust based package on CRAN it must meet certain
requirements. These are:
\itemize{
\item Rust dependencies are vendored
\item The package is compiled offline
\item the \code{DESCRIPTION} file's \code{SystemRequirements} field contains \verb{Cargo (Rust's package manager), rustc}
}

The extendr templates handle all of this \emph{except} vendoring dependencies.
This must be done prior to publication using \code{\link[=vendor_pkgs]{vendor_pkgs()}}.

In addition, it is important to make sure that CRAN maintainers
are aware that the package they are checking contains Rust code.
Depending on which and how many crates are used as a dependencies
the \code{vendor.tar.xz} will be larger than a few megabytes. If a
built package is larger than 5mbs CRAN may reject the submission.

To prevent rejection make a note in your \code{cran-comments.md} file
(create one using \code{\link[usethis:use_cran_comments]{usethis::use_cran_comments()}}) along the lines of
"The package tarball is 6mb because Rust dependencies are vendored within src/rust/vendor.tar.xz which is 5.9mb."
}

