% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_vscode.R
\name{use_vscode}
\alias{use_vscode}
\alias{use_positron}
\title{Set up VS Code configuration for an rextendr project}
\usage{
use_vscode(quiet = FALSE, overwrite = NULL)

use_positron(quiet = FALSE, overwrite = NULL)
}
\arguments{
\item{quiet}{If \code{TRUE}, suppress messages.}

\item{overwrite}{If \code{TRUE}, overwrite existing files.}
}
\value{
\code{TRUE} (invisibly) if the settings file was created or updated.
}
\description{
This creates a \code{.vscode} folder (if needed) and populates it with a
\code{settings.json} template. If already exists, it will be updated to include
the \code{rust-analyzer.linkedProjects} setting.
}
\details{
Rust-Analyzer VSCode extension looks for a \code{Cargo.toml} file in the
workspace root by default. This function creates a \code{.vscode} folder and
populates it with a \code{settings.json} file that sets the workspace root to
the \code{src} directory of the package. This allows you to open the package
directory in VSCode and have the Rust-Analyzer extension work correctly.
}
