% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/front_end.R
\name{velocities}
\alias{velocities}
\alias{velocities,missing-method}
\alias{velocities,character-method}
\title{Calculate velocities of plate tectonic movements}
\usage{
velocities(x, ...)

\S4method{velocities}{missing}(x, ...)

\S4method{velocities}{character}(
  x,
  age,
  model,
  domain = "longLatGrid",
  type = "MagAzim",
  output = "data.frame",
  polecrop = TRUE,
  verbose = FALSE,
  check = TRUE
)
}
\arguments{
\item{x}{\code{character}: What should the velocities be calculated for? If nothing is given (i.e. \code{signature(x="missing")}) the argument defaults to the only currently working feature collection, the \code{"static_polygons"}. This is expected to be expanded in the future.}

\item{...}{Arguments of class-specific methods.}

\item{age}{\code{numeric}: The age in millions of years at which the velocities are to be returned.}

\item{model}{\code{character}: The name of the tectonic model. Similar to that of \code{\link{reconstruct}}.}

\item{domain}{\code{character}: Either \code{"longLatGrid"} or \code{"healpix"}. \code{"longLatGrid"} returns the velocites with the domain of a regular, one-by-one degree longitude-latitude grid.
\code{"healpix"} will return velocities with the domain of an icosahedral, nearly equidistant grid.}

\item{type}{\code{character}: The type of velocity format that is to be returned, either magnitude and azimuth (\code{type="MagAzim"}) or easting and northing velocity vectors (\code{type="east_north"}).
Both result in two variables.}

\item{output}{\code{character}: The class name of the output to be returned. Either \code{data.frame} or \code{SpatRaster}. The latter requires the \code{terra} extension (suggested) and is only available with \code{domain="longLatGrid"}.}

\item{polecrop}{\code{logical}: Only applicable if \code{output="SpatRaster"}. The original velocity values are provided as a grid-registered raster,
which forces the extent of the raster to be beyond the regular \code{[-180, 180]} longitude and \code{[-90, 90]} domain, producing warnings when the \code{SpatRaster} is used.
The default \code{cellraster=TRUE} resamples this raster to a native, cell-registered grid.
This is an issue only with latitudes, so they get cropped by default. Setting this argument to \code{FALSE} will skip cropping.}

\item{verbose}{\code{logical}: Are you interested in more messages?}

\item{check}{\code{logical} Should the validity of the entries for the GWS checked with the information stored in \code{\link{gws}}? (default: \code{TRUE})}
}
\value{
Velocities of tectonic movements. If \code{output="data.frame"} then the function returns a \code{data.frame} with the longitude, latitude, the two velocity variables and the plate ids they belong to.
If \code{output="SpatRaster"} then the output will be a multilayered \code{SpatRaster} object.
}
\description{
Queries to return meshes of tectonic plate velocities.
}
\details{
The function returns a mesh of velocities: two variables, either magnitude (mm/year) and azimuth (rad): \code{type="MagAzim"} or easting and northing velocity vectors (mm/year): \code{type="east_north"}.
Currently only the online method is supported using the GPlates Web Service (internet connection is required).
Available models are in the \code{\link{gws}} object, and can be provided with arguments similar to \code{\link{reconstruct}}.
}
\examples{
# dummy example,
# set model to the desired model string, e.g. model="MERDITH2021"
velocities("static_polygons", age=45, model=NULL)
}
