% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhymer.R
\name{get_content}
\alias{get_content}
\title{Extract content from Datamuse API call.}
\usage{
get_content(full_path, return_type = "df", limit = 10)
}
\arguments{
\item{full_path}{API path to append to Datamuse API endpoint.}

\item{return_type}{type to return. Options are:
\itemize{
\item 'df' for data.frame.
\item 'word' for a single word.
\item 'random_word' or 'random word' or 'rand' for a random word.
\item 'vector' for a vector of words.
}}

\item{limit}{max number of rows to return from the content dataframe.}
}
\value{
content returned from API call.
}
\description{
Extract content from Datamuse API call.
}
\examples{
get_content("/words?rel_rhy=test", limit = 5)

get_content("/words?ml=test", limit = 20)
}
