% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadFile.R
\name{loadFile}
\alias{loadFile}
\title{Attempt to load a binary RData file}
\usage{
loadFile(rDataFile, env = parent.frame())
}
\arguments{
\item{rDataFile}{Character, RData file name}

\item{env}{Environment, where should be the RData loaded into. By default it
is loaded into the caller's environment.}
}
\value{
Logical, \code{TRUE} if the file was loaded successfully,
\code{FALSE} otherwise.
}
\description{
The function attempts to load a binary file, returning \code{TRUE} if
succeeded. Otherwise it returns \code{FALSE}.
}
\examples{
rf <- tempfile()
myData <- c(3,4,5)
save(myData, file=rf)
env <- new.env()
stopifnot(loadFile(rf, env=env))

}
\seealso{
\code{\link{iofile}} can be used to find file from input data
directory.
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
