% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzQC.R
\name{MzQCqualityMetric}
\alias{MzQCqualityMetric}
\alias{MzQCqualityMetric-class}
\title{The central class to store QC information}
\description{
The central class to store QC information

The central class to store QC information
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{accession}}{Accession number identifying the term within its controlled vocabulary.}

\item{\code{name}}{Name of the controlled vocabulary element describing the metric.}

\item{\code{description}}{(optional) Definition of the controlled vocabulary term.}

\item{\code{value}}{(optional) Value of the metric (single value, n-tuple, table, matrix).
The structure is not checked by our mzQC implementation and must be handled by the caller, see \code{\link{toQCMetric}}.}

\item{\code{unit}}{(optional) Array of unit(s), stored as MzQcvParameter}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MzQCqualityMetric-new}{\code{MzQCqualityMetric$new()}}
\item \href{#method-MzQCqualityMetric-isValid}{\code{MzQCqualityMetric$isValid()}}
\item \href{#method-MzQCqualityMetric-toJSON}{\code{MzQCqualityMetric$toJSON()}}
\item \href{#method-MzQCqualityMetric-fromData}{\code{MzQCqualityMetric$fromData()}}
\item \href{#method-MzQCqualityMetric-clone}{\code{MzQCqualityMetric$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCqualityMetric-new"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCqualityMetric-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCqualityMetric$new(
  accession = NA_character_,
  name = NA_character_,
  description = NA_character_,
  value = NA,
  unit = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{accession}}{String value for initialization of field accession}

\item{\code{name}}{String value for initialization of field name}

\item{\code{description}}{Optional string value for initialization of field description}

\item{\code{value}}{Optional value for initialization of field value}

\item{\code{unit}}{Optional unit value for initialization of field unit}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCqualityMetric-isValid"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCqualityMetric-isValid}{}}}
\subsection{Method \code{isValid()}}{
Verifies validity of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCqualityMetric$isValid(context = "MzQCqualityMetric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCqualityMetric-toJSON"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCqualityMetric-toJSON}{}}}
\subsection{Method \code{toJSON()}}{
Creates JSON file from this object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCqualityMetric$toJSON(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional parameters for jsonlite:::asJSON()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCqualityMetric-fromData"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCqualityMetric-fromData}{}}}
\subsection{Method \code{fromData()}}{
Sets data for this object from plain named lists of R objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCqualityMetric$fromData(data, context = "MzQCqualityMetric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A datastructure of R lists/arrays as obtained by 'jsonlite::fromJSON()'}

\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCqualityMetric-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCqualityMetric-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCqualityMetric$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
