% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot.juxtapose_function.R
\name{forestplot_juxtapose}
\alias{forestplot_juxtapose}
\title{Forest plot of juxtaposing several network meta-analysis models}
\usage{
forestplot_juxtapose(
  results,
  compar,
  name,
  drug_names,
  axis_title_size = 12,
  axis_text_size = 12,
  caption_text_size = 9,
  label_size = 3.5,
  position_width = 0.8
)
}
\arguments{
\item{results}{A list of at least two objects of S3 class
\code{\link{run_model}} or \code{\link{run_metareg}}. See 'Value' in
\code{\link{run_model}} and \code{\link{run_metareg}}.}

\item{compar}{A character to indicate the comparator intervention. It must
be any name found in \code{drug_names}.}

\item{name}{A vector of characters referring to the juxtaposed models. If the
argument is left unspecified, the names of models appear as 'Model X' with
'X' being the order/position of each model in the argument \code{results}.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data} of
\code{\link{run_model}}. If \code{drug_names} is not defined,
the order of the interventions as they appear in \code{data} is used,
instead.}

\item{axis_title_size}{A positive integer for the font size of x axis title.
\code{axis_title_size} determines the axis.title argument
found in the theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}

\item{axis_text_size}{A positive integer for the font size of axis text (both
axes). \code{axis_text_size} determines the axis.text argument found in the
theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}

\item{caption_text_size}{A positive integer for the font size of caption
text. \code{caption_text_size} determines the plot.caption argument found
in the theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}

\item{label_size}{A positive integer for the font size of labels appearing on
each interval. \code{label_size} determines the size argument found in the
geom's aesthetic properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}

\item{position_width}{A positive integer specifying the vertical position of
the intervals. \code{position_width} is found in the geom's aesthetic
properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}
}
\value{
A list of the following two figures:
  \item{forest_plots}{A panel of two forest plots: (1) a forest plot on the
  posterior median and 95\% credible and prediction intervals for comparisons
  with the selected comparator treatment (specified with \code{compar}), and
  (2) a forest plot on the posterior mean and 95\% credible interval of SUCRA
  values of the treatments (Salanti et al., 2011).}
  \item{tau_plot}{A forest plot on the posterior median and 95\% credible
  interval of the between-study standard deviation.}
}
\description{
Provides a forest plot with the posterior median and 95\% credible
  and prediction intervals for comparisons with the selected intervention
  (comparator) in the network under several network meta-analyses models, as
  well as a forest plot with the corresponding SUCRA values.
}
\details{
The y-axis of the forest plot on \bold{forest_plots} displays the
  labels of the treatments in the network; the selected treatment that
  comprises the \code{compar} argument is annotated in the plot with the
  label 'Comparator intervention'.
  For each comparison with the selected treatment, the 95\% credible and
  prediction intervals are displayed as overlapping lines. Black lines refer
  to estimation under both analyses. Coloured lines refer to prediction
  under each model, respectively. The corresponding numerical results are
  displayed above each line: 95\% credible intervals are found in
  parentheses, and 95\% predictive intervals are found in brackets.
  Odds ratios, relative risks, and ratio of means are reported in the
  original scale after exponentiation of the logarithmic scale.

  If one of the models refer to network meta-regression
  (\code{\link{run_metareg}}) the results on treatment effects (estimation
  and prediction) and SUCRA values refer to the covariate value selected
  when employing \code{\link{run_metareg}}.

  The y-axis for the forest plot on \bold{SUCRA} values displays the
  labels of the treatments in the network. The corresponding numerical
  results are displayed above each line.

  In \bold{forest_plots} and \bold{tau_plot}, the treatments are sorted in
  the descending order of their SUCRA values based on the first model
  specified in \code{results}.

  \bold{Important note:} \code{forestplot_juxtapose} should be used to
  compare the results from several network meta-analysis models that contain
  the same treatments, have the same meta-analysis model (fixed-effect or
  random-effects) and the same effect measure; otherwise the execution of the
  function will be stopped and an error message will be printed on the R
  console.

  \code{forestplot_juxtapose} is used only for a network of treatments.
  In the case of two treatments, the execution of the function will be
  stopped and an error message will be printed on the R console.
}
\references{
Salanti G, Ades AE, Ioannidis JP. Graphical methods and numerical summaries
for presenting results from multiple-treatment meta-analysis: an overview and
tutorial. \emph{J Clin Epidemiol} 2011;\bold{64}(2):163--71.
\doi{10.1016/j.jclinepi.2010.03.016}
}
\seealso{
\code{\link{run_metareg}}, \code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
