% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{selection_iis}
\alias{selection_iis}
\title{Create selection (non-outlying) vector from IIS model}
\usage{
selection_iis(x, data, yvar, complete, rownames_orig, refmodel)
}
\arguments{
\item{x}{An object of class \code{\link[ivgets:ivisat]{ivisat}}.}

\item{data}{A dataframe.}

\item{yvar}{A character vector of length 1 that refers to the name of the
dependent variable in the data set.}

\item{complete}{A logical vector with the same length as the number of
observations in the data set that specifies whether an observation has any
missing values in any of y, x, or z variables.}

\item{rownames_orig}{A character vector storing the original rownames of the
dataframe.}

\item{refmodel}{A model object that will be stored in \code{$model}.}
}
\value{
A list with five elements. The first four are vectors whose length
equals the number of observations in the data set. Unlike the residuals
stored in a model object (usually accessible via \code{model$residuals}), it
does not ignore observations where any of y, x or z are missing. It instead
sets their values to \code{NA}.

The first element is a double vector containing the residuals for each
observation based on the model estimates. The second element contains the
standardised residuals, the third one a logical vector with \code{TRUE} if
the observation is judged as not outlying, \code{FALSE} if it is an outlier,
and \code{NA} if any of y, x, or z are missing. The fourth element of the
list is an integer vector with three values: 0 if the observations is judged
to be an outlier, 1 if not, and -1 if missing. The fifth and last element
stores the \code{\link[ivreg]{ivreg}} model object based on which the four
vectors were calculated.
}
\description{
\code{selection_iis} uses the data and isat model object to create a list
with five elements that are used to determine whether the observations are
judged as outliers or not.
}
\section{Note}{

IIS runs multiple models, similar to \code{\link{saturated_init}} but with
multiple block search. These intermediate models are not recorded. For
simplicity, the element \code{$model} of the returned list stores the full
sample model result, identical to \code{\link{robustified_init}}.
}

\section{Warning}{

Unlike the residuals stored in a model object (usually accessible via
\code{model$residuals}), this function returns vectors of the same length as
the original data set even if any of the y, x, or z variables are missing.
The residuals for those observations are set to \code{NA}.
}

