% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateSensitivityCurveDatasets.R
\name{generateSensitivityCurveDatasets}
\alias{generateSensitivityCurveDatasets}
\title{Generate Datasets To Create Sensitivity Curves}
\usage{
generateSensitivityCurveDatasets(
  data,
  observationsToChange,
  shifts,
  scales,
  center,
  formula,
  ...
)
}
\arguments{
\item{data}{dataset to be modified.}

\item{observationsToChange}{index or logical vector indicating which
observations should be modified.}

\item{shifts}{vector of shifts that should be applied one by one to each of
the modified observations.}

\item{scales}{vector scales that should be used to scale the observations
around their original center.}

\item{center}{optional scalar used to define the center from which the
observations are scaled from. If missing, the mean of all the changed
observations is used.}

\item{formula}{formula to fit the model using \code{lmer}.}

\item{...}{all additional arguments are added to the returned list.}
}
\value{
list that can be passed to \code{\link{processFit}} and to any of
  the \code{\link{fitDatasets}} functions. Only \code{generateData} is
  implemented, all the other functions return an error if called.
}
\description{
This method creates a list of datasets that can be used to create
sensitivity curves. The response of the dataset is modified according to the
supplied arguments.
}
\details{
Either \code{shifts} or \code{scales} need to be provided. Both are also
possible.

The argument \code{shifts} contains all the values that shall be added to
each of the observations that should be changed. One value per generated
dataset.

The argument \code{scales} contains all the values that shall be used to
move observations away from their center. If \code{scales} is provided, then
\code{observationsToChange} needs to select more than one observation.

The returned list can be passed to \code{\link{processFit}} and to any of
the \code{\link{fitDatasets}} functions. Splitting and binding of datasets
using \code{\link{splitDatasets}} and \code{\link{bindDatasets}} is not
supported.
}
\examples{
  oneWay <- generateAnovaDatasets(1, 1, 10, 5)
  datasets <-
      generateSensitivityCurveDatasets(oneWay$generateData(1),
                                       observationsToChange = 1:5,
                                       shifts = -10:10,
                                       formula = oneWay$formula)
  datasets$generateData(1)
}
\seealso{
\code{\link{generateAnovaDatasets}}
}
