% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cstep}
\alias{cstep}
\title{C-step of Matrix Minimum Covariance Determinant (MMCD) Estimator}
\usage{
cstep(
  X,
  alpha = 0.5,
  cov_row_init = NULL,
  cov_col_init = NULL,
  diag = "none",
  h_init = -1L,
  init = TRUE,
  max_iter = 100L,
  max_iter_MLE = 100L,
  lambda = 0,
  adapt_alpha = TRUE
)
}
\arguments{
\item{X}{a 3d array of dimension \eqn{(p,q,n)}, containing \eqn{n} matrix-variate samples of \eqn{p} rows and \eqn{q} columns in each slice.}

\item{alpha}{numeric parameter between 0.5 (default) and 1. Controls the size \eqn{h \approx alpha * n} of the h-subset over which the determinant is minimized.}

\item{cov_row_init}{matrix. Initial \code{cov_row} \eqn{p \times p} matrix. Identity by default.}

\item{cov_col_init}{matrix. Initial \code{cov_col} \eqn{p \times p} matrix. Identity by default.}

\item{diag}{Character. If "none" (default) all entries of \code{cov_row} and \code{cov_col} are estimated. If either "both", "row", or "col" only the diagonal entries of the respective matrices are estimated.}

\item{h_init}{Integer. Size of initial h-subset. If smaller than 0 (default) size is chosen automatically.}

\item{init}{Logical. If TRUE (default) elemental subsets are used to initialize the procedure.}

\item{max_iter}{upper limit of C-step iterations (default is 100)}

\item{max_iter_MLE}{upper limit of MLE iterations (default is 100)}

\item{lambda}{a smooting parameter for the rowwise and columnwise covariance matrices.}

\item{adapt_alpha}{Logical. If TRUE (default) alpha is adapted to take the dimension of the data into account.}
}
\value{
A list containing the following:
\item{\code{mu}}{Estimated \eqn{p \times q} mean matrix.}
\item{\code{cov_row}}{Estimated \eqn{p} times \eqn{p} rowwise covariance matrix.}
\item{\code{cov_col}}{Estimated \eqn{q} times \eqn{q} columnwise covariance matrix.}
\item{\code{cov_row_inv}}{Inverse of \code{cov_row}.}
\item{\code{cov_col_inv}}{Inverse of \code{cov_col}.}
\item{\code{md}}{Squared Mahalanobis distances.}
\item{\code{md_raw}}{Squared Mahalanobis distances based on \emph{raw} MMCD estimators.}
\item{\code{det}}{Value of objective function (determinant of Kronecker product of rowwise and columnwise covariane).}
\item{\code{dets}}{Objective values for the final h-subsets.}
\item{\code{h_subset}}{Final h-subset of \emph{raw} MMCD estimators.}
\item{\code{iterations}}{Number of C-steps.}
}
\description{
This function is part of the FastMMCD algorithm \insertCite{mayrhofer2024}{robustmatrix}.
}
\examples{
n = 1000; p = 2; q = 3
mu = matrix(rep(0, p*q), nrow = p, ncol = q)
cov_row = matrix(c(1,0.5,0.5,1), nrow = p, ncol = p)
cov_col = matrix(c(3,2,1,2,3,2,1,2,3), nrow = q, ncol = q)
X <- rmatnorm(n = 1000, mu, cov_row, cov_col)
ind <- sample(1:n, 0.3*n)
X[,,ind] <- rmatnorm(n = length(ind), matrix(rep(10, p*q), nrow = p, ncol = q), cov_row, cov_col)
par_mmle <- mmle(X)
par_cstep <- cstep(X)
distances_mmle <- mmd(X, par_mmle$mu, par_mmle$cov_row, par_mmle$cov_col)
distances_cstep <- mmd(X, par_cstep$mu, par_cstep$cov_row, par_cstep$cov_col)
plot(distances_mmle, distances_cstep)
abline(h = qchisq(0.99, p*q), lty = 2, col = "red")
abline(v = qchisq(0.99, p*q), lty = 2, col = "red")
}
\seealso{
\code{\link{mmcd}}
}
