% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkPkgs.R
\name{checkPkgs}
\alias{checkPkgs}
\title{Check for presence of a package}
\usage{
checkPkgs(
  ...,
  install = FALSE,
  load = FALSE,
  repos = "https://cran.rstudio.com"
)
}
\arguments{
\item{...}{A series of packages. If the packages are named, the
names are the package names, and the values are the minimum required
package versions (see the second example).}

\item{install}{Whether to install missing packages from \code{repos}.}

\item{load}{Whether to load packages (which is exactly \emph{not} the point
of this package, but hey, YMMV).}

\item{repos}{The repository to use if installing packages; default
is the RStudio repository.}
}
\value{
Invisibly, a vector of the available packages.
}
\description{
This function efficiently checks for the presence of a package
without loading it (unlike \code{\link[=library]{library()}} or \code{\link[=require]{require()}}.
This is useful to force yourself to use the package::function
syntax for addressing functions; you can make sure required packages
are installed, but their namespace won't attach to the search path.
}
\examples{
\donttest{
rock::checkPkgs('base');

### Require a specific version
rock::checkPkgs(rock = "0.9.1");

### This will show the error message
tryCatch(
  rock::checkPkgs(
    base = "99",
    stats = "42.5",
    rock = 2000
  ),
  error = print
);
}
}
