% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_uids.R
\name{extract_uids}
\alias{extract_uids}
\title{Extract the UIDs (or SQUIDs) from a vector}
\usage{
extract_uids(x, returnSQUIDs = FALSE)
}
\arguments{
\item{x}{The vector}

\item{returnSQUIDs}{WHether to return the UIDs or the SQUIDs.}
}
\value{
A vector with (SQ)UIDs
}
\description{
Extract the UIDs (or SQUIDs) from a vector
}
\examples{
exampleText <- c(
  "Lorem ipsum dolor sit amet, consectetur",
  "adipiscing elit. Nunc non commodo ex,",
  "ac varius mi. Praesent feugiat nunc",
  "eget urna euismod lobortis. Sed",
  "hendrerit suscipit nisl, ac tempus",
  "magna porta et. Quisque libero massa,",
  "tempus vel tristique lacinia, tristique",
  "in nulla. Nam cursus enim dui, non",
  "ornare est tempor eu. Vivamus et massa",
  "consectetur, tristique magna eget,",
  "viverra elit."
);

withUIDs <-
  rock::prepend_ids_to_source(
    exampleText
  );

rock::extract_uids(
  withUIDs
);
}
