% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolayer.R
\name{get_variable_description}
\alias{get_variable_description}
\alias{get_variable_description.geolayer}
\title{Get variable description}
\usage{
get_variable_description(gl, name, only_values)

\method{get_variable_description}{geolayer}(gl, name = NULL, only_values = FALSE)
}
\arguments{
\item{gl}{A \code{geolayer} object.}

\item{name}{A string vector.}

\item{only_values}{A boolean, add names to component values.}
}
\value{
A string vector.
}
\description{
Obtain a description of the variables whose name is indicated. If no name is
indicated, all are returned.
}
\details{
Using the parameter \code{only_values}, we can obtain only the combination of values
or also the combination of names with values.
}
\examples{

gl <- mrs_db_geo |>
  as_geolayer()

vd <- gl |>
  get_variable_description()

}
\seealso{
Other query functions: 
\code{\link{as_GeoPackage}()},
\code{\link{as_geolayer}()},
\code{\link{filter_dimension}()},
\code{\link{get_layer}()},
\code{\link{get_variables}()},
\code{\link{run_query}()},
\code{\link{select_dimension}()},
\code{\link{select_fact}()},
\code{\link{set_layer}()},
\code{\link{set_variables}()},
\code{\link{star_query}()}
}
\concept{query functions}
