% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_api.R
\name{route}
\alias{route}
\title{Construct a new route}
\usage{
route(..., root = "")
}
\arguments{
\item{...}{Handlers to add up front. Must be in the form of named lists
where the names corresponds to paths and the elements are the handlers.
The name of the argument itself defines the method to listen on (see
examples)}

\item{root}{The root of the route. Will be removed from the path of any
request before matching a handler}
}
\value{
A \link{Route} object
}
\description{
This function constructs a new \link{Route}, optionally with a set of handlers
already attached.
}
\examples{
# An empty route
route <- route()
route

# Prepopulating it at construction
route <- route(all = list(
  '/*' = function(request, response, keys, ...) {
    message('Request received')
    TRUE
  }
))
route

}
