% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deployApp.R
\name{deployApp}
\alias{deployApp}
\title{Deploy an Application}
\usage{
deployApp(
  appDir = getwd(),
  appFiles = NULL,
  appFileManifest = NULL,
  manifestPath = NULL,
  appPrimaryDoc = NULL,
  appSourceDoc = NULL,
  appName = NULL,
  appTitle = NULL,
  envVars = NULL,
  appId = NULL,
  appMode = NULL,
  contentCategory = NULL,
  account = NULL,
  server = NULL,
  upload = TRUE,
  recordDir = NULL,
  launch.browser = getOption("rsconnect.launch.browser", is_interactive()),
  on.failure = NULL,
  logLevel = c("normal", "quiet", "verbose"),
  lint = TRUE,
  metadata = list(),
  forceUpdate = NULL,
  python = NULL,
  forceGeneratePythonEnvironment = FALSE,
  quarto = NA,
  appVisibility = NULL,
  image = NULL,
  envManagement = NULL,
  envManagementR = NULL,
  envManagementPy = NULL
)
}
\arguments{
\item{appDir}{A directory containing an application (e.g. a Shiny app
or plumber API). Defaults to the current directory.}

\item{appFiles, appFileManifest}{Use \code{appFiles} to specify a
character vector of files to bundle in the app or \code{appFileManifest}
to provide a path to a file containing a list of such files. If neither
are supplied, will bundle all files in \code{appDir}, apart from standard
exclusions and files listed in a \code{.rscignore} file. See
\code{\link[=listDeploymentFiles]{listDeploymentFiles()}} for more details.}

\item{manifestPath}{Path to an existing \code{manifest.json} file to use for
deployment. When provided, \code{deployApp()} will use the file list and
metadata from this manifest instead of generating a new one. This allows
you to pre-generate a manifest with \code{\link[=writeManifest]{writeManifest()}}, customize it, check
it into version control, and deploy from that exact manifest. If \code{NULL}
(the default), a new manifest will be generated. When using \code{manifestPath},
\code{appFiles}, \code{appFileManifest}, \code{appMode}, \code{appPrimaryDoc}, \code{contentCategory},
\code{envManagement(R|Py)}, and \code{image} are ignored since their values are taken
from the manifest.}

\item{appPrimaryDoc}{If the application contains more than one document, this
parameter indicates the primary one, as a path relative to \code{appDir}. Can be
\code{NULL}, in which case the primary document is inferred from the contents
being deployed.}

\item{appSourceDoc}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{recordDir} instead.}

\item{appName}{Application name, a string consisting of letters, numbers,
\verb{_} and \code{-}. The application name is used to identify applications on a
server, so must be unique.

If not specified, the first deployment will be automatically it from the
\code{appDir} for directory and website, and from the \code{appPrimaryDoc} for
document. On subsequent deploys, it will use the previously stored value.}

\item{appTitle}{Free-form descriptive title of application. Optional; if
supplied, will often be displayed in favor of the name. If ommitted,
on second and subsequent deploys, the title will be unchanged.}

\item{envVars}{A character vector giving the names of environment variables
whose values should be synchronised with the server (currently supported by
Connect only). The values of the environment variables are sent over an
encrypted connection and are not stored in the bundle, making this a safe
way to send private data to Connect.

The values of sensitive environment variables should be set in the current
session via an \code{.Renviron} file or with the help of a credential store like
\href{https://keyring.r-lib.org/}{keyring}. Avoid using
\code{\link[=Sys.setenv]{Sys.setenv()}} for sensitive values, as that results in the value appearing
in your \code{.Rhistory}.

The names (not values) are stored in the deployment record so that future
deployments will automatically update their values. Other environment
variables on the server will not be affected. This means that removing an
environment variable from \code{envVars} will leave it unchanged on the server.
To remove it, either delete it using the Connect UI, or temporarily unset
it (with \code{\link[=Sys.unsetenv]{Sys.unsetenv()}} or similar) then re-deploy.

Environment variables are set prior to deployment so that your code
can use them and the first deployment can still succeed. Note that means
that if the deployment fails, the values will still be updated.}

\item{appId}{Use this to deploy to an exact known application, ignoring all
existing deployment records and \code{appName}.

You can use this to update an existing application that is missing a
deployment record. If you're re-deploying an application that you
created it's generally easier to use \code{appName}; \code{appId} is best reserved
for re-deploying apps created by someone else.

You can find the \code{appId} in the following places:
\itemize{
\item For Posit Connect, it's \code{guid} from the info tab on the content page.
\item For Posit Connect Cloud, it can be found in the content admin page's URL \verb{https://connect.posit.cloud/\{accountName\}/content/\{appId\}}).
\item On shinyapps.io, it's the \code{id} listed on the applications page.
}}

\item{appMode}{Optional; the type of content being deployed.
Provide this option when the inferred type of content is incorrect. This
can happen, for example, when static HTML content includes a downloadable
Shiny application \code{app.R}. Accepted values include \code{"shiny"}, \code{"api"},
\code{"rmd-static"}, \code{"rmd-shiny"}, \code{"quarto-static"}, \code{"quarto-shiny"}, and
\code{"static"}. The Posit Connect API Reference contains a full set of
available values. Not all servers support all types of content.}

\item{contentCategory}{Optional; classifies the kind of content being
deployed (e.g. \code{"plot"} or \code{"site"}).}

\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}

\item{upload}{If \code{TRUE} (the default) then the application is uploaded from
the local system prior to deployment. If \code{FALSE} then it is re-deployed
using the last version that was uploaded. \code{FALSE} is only supported on
Posit Connect Cloud and shinyapps.io; \code{TRUE} is required on Posit Connect.}

\item{recordDir}{Directory where deployment record is written. The default,
\code{NULL}, uses \code{appDir}, since this is usually where you want the deployment
data to be stored. This argument is typically only needed when deploying
a directory of static files since you want to store the record with the
code that generated those files, not the files themselves.}

\item{launch.browser}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to \code{TRUE} in
interactive sessions only. If a function is passed, it will be called
after the app is started, with the app URL as a paramter.}

\item{on.failure}{Function to be called if the deployment fails. If a
deployment log URL is available, it's passed as a parameter.}

\item{logLevel}{One of \code{"quiet"}, \code{"normal"} or \code{"verbose"}; indicates how
much logging to the console is to be performed. At \code{"quiet"} reports no
information; at \code{"verbose"}, a full diagnostic log is captured.}

\item{lint}{Lint the project before initiating deployment, to identify
potentially problematic code?}

\item{metadata}{Additional metadata fields to save with the deployment
record. These fields will be returned on subsequent calls to
\code{\link[=deployments]{deployments()}}.

Multi-value fields are recorded as comma-separated values and returned in
that form. Custom value serialization is the responsibility of the caller.}

\item{forceUpdate}{What should happen if there's no deployment record for
the app, but there's an app with the same name on the server? If \code{TRUE},
will always update the previously-deployed app. If \code{FALSE}, will ask
the user what to do, or fail if not in an interactive context.

Defaults to \code{TRUE} when called automatically by the IDE, and \code{FALSE}
otherwise. You can override the default by setting option
\code{rsconnect.force.update.apps}.}

\item{python}{Full path to a python binary for use by \code{reticulate}.
Required if \code{reticulate} is a dependency of the app being deployed.
If python = NULL, and RETICULATE_PYTHON or RETICULATE_PYTHON_FALLBACK is
set in the environment, its value will be used. The specified python binary
will be invoked to determine its version and to list the python packages
installed in the environment.}

\item{forceGeneratePythonEnvironment}{Optional. If an existing
\code{requirements.txt} file is found, it will be overwritten when this argument
is \code{TRUE}.}

\item{quarto}{Should the deployed content be built by quarto?
(\code{TRUE}, \code{FALSE}, or \code{NA}). The default, \code{NA}, will use quarto if
there are \code{.qmd} files in the bundle, or if there is a
\verb{_quarto.yml} and \code{.Rmd} files.

(This option is ignored and quarto will always be used if the
\code{metadata} contains \code{quarto_version} and \code{quarto_engines} fields.)}

\item{appVisibility}{One of \code{NULL}, \code{"private"}, or \code{"public"}; the
visibility of the deployment. When \code{NULL}, no change to visibility is
made. Currently has an effect only on deployments to shinyapps.io.}

\item{image}{Optional. The name of the image to use when building and
executing this content. If none is provided, Posit Connect will
attempt to choose an image based on the content requirements. You can
override the default by setting the environment variable \code{RSCONNECT_IMAGE}.}

\item{envManagement}{Optional. Should Posit Connect install R and Python
packages for this content? (\code{TRUE}, \code{FALSE}, or \code{NULL}).
The default, \code{NULL}, will not write any values to the bundle manifest,
and Connect will fall back to the application default environment
management strategy, or the server default if no application default
is defined.

(This option is a shorthand flag which overwrites the values of both
\code{envManagementR} and \code{envManagementPy}.)}

\item{envManagementR}{Optional. Should Posit Connect install R packages
for this content? (\code{TRUE}, \code{FALSE}, or \code{NULL}). The default, \code{NULL}, will
not write any values to the bundle manifest, and Connect will fall back to
the application default R environment management strategy, or the server
default if no application default is defined.

(This option is ignored when \code{envManagement} is non-\code{NULL}.)}

\item{envManagementPy}{Optional. Should Posit Connect install Python packages
for this content? (\code{TRUE}, \code{FALSE}, or \code{NULL}). The default, \code{NULL}, will
not write any values to the bundle manifest, and Connect will fall back to
the application default Python environment management strategy, or the
server default if no application default is defined.

(This option is ignored when \code{envManagement} is non-\code{NULL}.)}
}
\description{
Deploy a \link[shiny:shiny-package]{shiny} application, an
\link[rmarkdown:rmarkdown-package]{RMarkdown} document, a plumber API, or HTML
content to a server.

Supported servers: All servers
}
\details{
\subsection{Deployment records}{

When deploying an app, \code{deployApp()} will save a deployment record that
makes it easy to update the app on server from your local source code. This
generally means that you need to only need to supply important arguments
(e.g. \code{appName}, \code{appTitle}, \code{server}/\code{account}) on the first deploy, and
rsconnect will reuse the same settings on subsequent deploys.

The metadata needs to make this work is stored in \verb{\{appDir\}/rsconnect/}.
You should generally check these files into version control to ensure that
future you and other collaborators will publish to the same location.

If you have lost this directory, all is not lost, as \code{deployApp()} will
attempt to rediscover existing deployments. This is easiest if you are
updating an app that you created, as you can just supply the \code{appName}
(and \code{server}/\code{account} if you have multiple accounts) and \code{deployApp()}
will find the existing application account. If you need to update an app
that was created by someone else (that you have write permission) for, you'll
instead need to supply the \code{appId}.
}
}
\examples{
\dontrun{

# deploy the application in the current working dir
deployApp()

# deploy an application in another directory
deployApp("~/projects/shiny/app1")

# deploy using an alternative application name and title
deployApp("~/projects/shiny/app1", appName = "myapp",
          appTitle = "My Application")

# deploy specifying an explicit account name, then
# redeploy with no arguments (will automatically use
# the previously specified account)
deployApp(account = "jsmith")
deployApp()

# deploy but don't launch a browser when completed
deployApp(launch.browser = FALSE)

# deploy a Quarto website, using the quarto package to
# find the Quarto binary
deployApp("~/projects/quarto/site1")

# deploy application with environment variables
# (e.g., `SECRET_PASSWORD=XYZ` is set via an ~/.Renviron file)
rsconnect::deployApp(envVars = c("SECRET_PASSWORD"))

# deploy from a pre-generated manifest
writeManifest("~/projects/shiny/app1")
# ...optionally customize manifest.json here...
deployApp("~/projects/shiny/app1", manifestPath = "manifest.json")
}
}
\seealso{
\code{\link[=applications]{applications()}}, \code{\link[=terminateApp]{terminateApp()}}, and \code{\link[=restartApp]{restartApp()}}

Other Deployment functions: 
\code{\link{applications}()},
\code{\link{deployAPI}()},
\code{\link{deployDoc}()},
\code{\link{deploySite}()},
\code{\link{deployTFModel}()}
}
\concept{Deployment functions}
