% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_as_docx.R
\name{export_as_docx}
\alias{export_as_docx}
\alias{section_properties_default}
\alias{margins_potrait}
\alias{margins_landscape}
\title{Export to a Word document}
\usage{
export_as_docx(
  tt,
  file,
  add_page_break = FALSE,
  add_template_page_numbers = TRUE,
  titles_as_header = TRUE,
  integrate_footers = TRUE,
  section_properties = section_properties_default(),
  doc_metadata = NULL,
  template_file = NULL,
  ...
)

section_properties_default(
  page_size = c("letter", "A4"),
  orientation = c("portrait", "landscape")
)

margins_potrait()

margins_landscape()
}
\arguments{
\item{tt}{(\code{TableTree} or related class)\cr a \code{TableTree} object representing a populated table.}

\item{file}{(\code{string})\cr output file. Must have \code{.docx} extension.}

\item{add_page_break}{(\code{flag})\cr whether to add a page break after the table (\code{TRUE}) or not (\code{FALSE}).}

\item{add_template_page_numbers}{(\code{flag})\cr whether to add page numbers to the word document as page footer. This
uses templates to achieve it. Defaults to \code{TRUE}. Consider adding your own template file if you want
more customization.}

\item{titles_as_header}{(\code{flag})\cr Controls how titles are rendered relative to the table.
If \code{TRUE} (default), the main title (\code{\link[formatters:title_footer]{formatters::main_title()}}) and subtitles
(\code{\link[formatters:title_footer]{formatters::subtitles()}}) are added as distinct header rows within the
\code{flextable} object itself. If \code{FALSE}, titles are rendered as a separate paragraph
of text placed immediately before the table.}

\item{integrate_footers}{(\code{flag})\cr Controls how footers are rendered relative to the table.
If \code{TRUE} (default), footers (e.g., \code{\link[formatters:title_footer]{formatters::main_footer()}}, \code{\link[formatters:title_footer]{formatters::prov_footer()}})
are integrated directly into the \code{flextable} object, typically appearing as footnotes
below the table body with a smaller font. If \code{FALSE}, footers are rendered as a
separate paragraph of text placed immediately after the table.}

\item{section_properties}{(\code{officer::prop_section})\cr an \code{\link[officer:prop_section]{officer::prop_section()}} object which sets margins and
page size. Defaults to \code{\link[=section_properties_default]{section_properties_default()}}.}

\item{doc_metadata}{(\code{list} of \code{string})\cr any value that can be used as metadata by
\code{\link[officer:set_doc_properties]{officer::set_doc_properties()}}. Important text values are \code{title}, \code{subject}, \code{creator}, and \code{description},
while \code{created} is a date object.}

\item{template_file}{(\code{string})\cr template file that \code{officer} will use as a starting point for the final
document. Document attaches the table and uses the defaults defined in the template file.}

\item{...}{(\code{any})\cr additional arguments passed to \code{\link[=tt_to_flextable]{tt_to_flextable()}}.}

\item{page_size}{(\code{string}) page size. Can be \code{"letter"} or \code{"A4"}. Defaults to \code{"letter"}.}

\item{orientation}{(\code{string}) page orientation. Can be \code{"portrait"} or \code{"landscape"}. Defaults to \code{"portrait"}.}
}
\value{
No return value, called for side effects
}
\description{
From an \code{rtables} table, produce a self-contained Word document or attach it to a template Word
file (\code{template_file}). This function is based on the \code{\link[=tt_to_flextable]{tt_to_flextable()}} transformer and
the \code{officer} package.
}
\details{
Pagination Behavior for Titles and Footers (this behavior is experimental at the moment):

The rendering of titles and footers interacts with table pagination as follows:
\itemize{
\item \strong{Titles:} When \code{titles_as_header = TRUE} (default), the integrated title
header rows typically repeat at the top of each new page if the table spans
multiple pages. Setting \code{titles_as_header = FALSE} renders titles as a
separate paragraph only once before the table begins.
\item \strong{Footers:} Regardless of the \code{integrate_footers} setting, footers appear
only once. Integrated footnotes (\code{integrate_footers = TRUE}) appear at the
very end of the complete table, and separate text paragraphs
(\code{integrate_footers = FALSE}) appear after the complete table. Footers
do not repeat on each page.
}
}
\section{Functions}{
\itemize{
\item \code{section_properties_default()}: Helper function that defines standard portrait properties for tables.

\item \code{margins_potrait()}: Helper function that defines standard portrait margins for tables.

\item \code{margins_landscape()}: Helper function that defines standard landscape margins for tables.

}}
\note{
\code{export_as_docx()} has few customization options available. If you require specific formats and details,
we suggest that you use \code{\link[=tt_to_flextable]{tt_to_flextable()}} prior to \code{export_as_docx()}. If the table is modified first using
\code{\link[=tt_to_flextable]{tt_to_flextable()}}, the \code{titles_as_header} and \code{integrate_footers} parameters must be re-specified.
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze(c("AGE", "BMRKR2", "COUNTRY"))

tbl <- build_table(lyt, ex_adsl)

# See how the section_properties_portrait() function is built for customization
tf <- tempfile(tmpdir = tempdir(check = TRUE), fileext = ".docx")
export_as_docx(tbl,
  file = tf,
  section_properties = section_properties_default(orientation = "landscape")
)

}
\seealso{
\code{\link[=tt_to_flextable]{tt_to_flextable()}}
}
