% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{missing}
\alias{missing}
\alias{anyNA.rvec}
\alias{is.na.rvec}
\alias{na.exclude.rvec}
\alias{na.omit.rvec}
\title{Missing, Finite, and Infinite Values
in Rvecs}
\usage{
\method{anyNA}{rvec}(x, recursive = FALSE)

\method{is.na}{rvec}(x)

\method{na.exclude}{rvec}(object, ...)

\method{na.omit}{rvec}(object, ...)
}
\arguments{
\item{x, object}{An \link[=rvec]{rvec}.}

\item{recursive}{Whether \code{anyNA()} should be
applied recursively to lists. Ignored when
\code{x} is an rvec.}

\item{...}{Currently ignored.}
}
\value{
\itemize{
\item \code{anyNA()} A logical rvec with length 1.
\item \code{is.na()}, \code{is.nan()}, \code{is.finite()}, \code{is.infinite()} A
logical rvec with the same length as the original rvec.
\item \code{na.omit()}, \code{na.exclude()} An rvec with the same
class as the original rvec, minus any elements that
have \code{NA}s in any draws.
\item \code{na.fail()} The original rvec, or an error.
}
}
\description{
Detect or remove missing and infinite values in rvecs.
Operations are done independently on each draw,
though \code{na.omit()}, \code{na.exclude()}, and \code{na.fail()}
also look across draws.
}
\details{
The behavior of the rvec methods
for \code{is.na()}, \code{is.nan()},
\code{is.finite()}, and \code{is.infinite()}
differs from the standard
\href{https://vctrs.r-lib.org}{vctrs}
behavior, which is to return a logical
vector with length equal to \code{length(x)}.
With rvecs, the standard \pkg{vctrs} behavior
would entail summarising across draws,
which is the job of the \link[=draws_all]{draws_*}
functions.
}
\examples{
x <- rvec(list(c(1.2, NA),
               c(Inf, 3),
               c(-1, NaN)))

## return a logical rvec
is.na(x)
is.nan(x)
is.finite(x)
is.infinite(x)

## return a logical rvec with length 1
anyNA(x)

## summarise across draws
draws_any(anyNA(x))

## return an NA-free version of 'x'
na.omit(x)
na.exclude(x)

## use 'if_else_rvec' to modify values
## within rvec
if_else_rvec(is.na(x), 999, x)

## vctrs functions
library(vctrs, warn.conflicts = FALSE)
## all draws missing
vec_detect_missing(x)
## any draws missing
vec_detect_complete(x)
}
\seealso{
\itemize{
\item \code{\link[=if_else_rvec]{if_else_rvec()}} Modify individual
values within draws
\item \code{\link[=is.na]{is.na()}}, \code{\link[=is.nan]{is.nan()}},
\code{\link[=is.finite]{is.finite()}}, \code{\link[=is.infinite]{is.infinite()}},
\code{\link[=anyNA]{anyNA()}}, \code{\link[=na.omit]{na.omit()}}, \code{\link[=na.exclude]{na.exclude()}} Base R functions
\item \code{\link[vctrs:missing]{vctrs::vec_detect_missing()}} Test whether
all draws for an observation are missing
\item \code{\link[vctrs:vec_detect_complete]{vctrs::vec_detect_complete()}} Test whether
any draws for an observation are missing
\item \code{\link[=draws_any]{draws_any()}}, \code{\link[=draws_all]{draws_all()}} Summarise
across draws
}
}
