% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{summarise_by_period}
\alias{summarise_by_period}
\title{Summaries by period}
\usage{
summarise_by_period(data, period, .funs, ...)
}
\arguments{
\item{data}{sapflow or environmental data as obtained by \code{\link{get_sapf_data}}
and \code{\link{get_env_data}}. Must have a column named TIMESTAMP}

\item{period}{period to collapse by. See \code{\link{sfn_metrics}} for details.}

\item{.funs}{funs to summarise the data. See details.}

\item{...}{optional arguments. See details}
}
\value{
A `tbl_df` object with the metrics results. The names of the columns
  indicate the original variable (tree or environmental variable) and the
  metric calculated (i.e. `vpd_mean`), separated by underscore
}
\description{
This function collapse the TIMESTAMP to the desired period (day, month...)
by setting the same value to all timestamps within the period. This modified
TIMESTAMP is used to group by and summarise the data.
}
\details{
This function uses internally \code{\link{.collapse_timestamp}} and
\code{\link[dplyr]{summarise_all}}. Arguments to control these functions
can be passed as `...`. Arguments for each function are spliced and applied
when needed. Be advised that all arguments passed to the summarise_all function
will be applied to all the summarising functions used, so it will fail if any
of that functions does not accept that argument. To complex function-argument
relationships, indicate each summary function call within the \code{.funs}
argument as explained here \code{\link[dplyr]{summarise_all}}:
\preformatted{
# This will fail beacuse na.rm argument will be also passed to the n function,
# which does not accept any argument:
summarise_by_period(
  data = get_sapf_data(ARG_TRE),
  period = '7 days',
  .funs = list(mean, sd, n()),
  na.rm = TRUE
)

# to solve this is better to use the .funs argument:
summarise_by_period(
  data = get_sapf_data(ARG_TRE),
  period = '7 days',
  .funs = list(~ mean(., na.rm = TRUE), ~ sd(., na.rm = TRUE), ~ n())
)
}
}
\section{TIMESTAMP_coll}{

  Previously to the collapsing step, a temporal variable called
  \code{TIMESTAMP_coll} is created to be able to catch the real timestamp when
  some events happens, for example to use the \code{min_time} function. If
  your custom summarise function needs to get the time at which some event
  happens, use TIMESTAMP_coll instead of TIMESTAMP for that:
  \preformatted{
    min_time <- function(x, time) {
      time[which.min(x)]
    }

    summarise_by_period(
      data = get_sapf_data(ARG_TRE),
      period = '1 day',
      .funs = list(~ min_time(., time = TIMESTAMP_coll)) # Not TIMESTAMP
    )
  }
}

\examples{
library(dplyr)

# data
data('ARG_TRE', package = 'sapfluxnetr')

# simple summary
summarise_by_period(
  data = get_sapf_data(ARG_TRE),
  period = '7 days',
  .funs = list(~ mean(., na.rm = TRUE), ~ sd(., na.rm = TRUE), ~ n())
)

}
