% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_scholid.R
\name{normalize_scholid}
\alias{normalize_scholid}
\title{Normalize scholarly identifiers}
\usage{
normalize_scholid(x, type)
}
\arguments{
\item{x}{A vector of values to normalize.}

\item{type}{A single string giving the identifier type. See
\code{\link[=scholid_types]{scholid_types()}} for supported values.}
}
\value{
A character vector with the same length as \code{x}. Invalid or
structurally non-matching inputs yield \code{NA_character_}.
}
\description{
Vectorized normalizer that converts supported scholarly identifier values
to a canonical form (e.g., removing URL prefixes, labels, or separators).

Normalization is structural: inputs that conform to the expected identifier
syntax are converted to a canonical representation. Inputs that do not match
the required structure yield \code{NA_character_}.

For identifier types with checksum algorithms (e.g., ORCID, ISBN, ISSN),
normalization does not verify checksum correctness. It only enforces
structural plausibility and canonical formatting.

Use \code{\link[=is_scholid]{is_scholid()}} to test whether values are fully valid identifiers,
including checksum verification where applicable.
}
\examples{
normalize_scholid("https://doi.org/10.1000/182", "doi")
normalize_scholid("https://orcid.org/0000-0002-1825-0097", "orcid")

}
\seealso{
\code{\link[=is_scholid]{is_scholid()}}, \code{\link[=scholid_types]{scholid_types()}}
}
