% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclustDepart.R
\name{sigp}
\alias{sigp}
\title{Significance for first split using sigclust2}
\usage{
sigp(test_dat, minSize = 10, sim = 100)
}
\arguments{
\item{test_dat}{A UMI count matrix with samples as rows and features as columns.}

\item{minSize}{Numeric, the minimal allowable cluster size (default 10).}

\item{sim}{Numeric, the number of Monte Carlo simulations (default 100).}
}
\value{
A list with the following elements:
\describe{
  \item{\code{p}}{P-value for the first split.}
  \item{\code{z}}{Z-score for the first split.}
  \item{\code{shc_result}}{An S3 object of class \code{shc}, as defined in the sigclust2 package.}
  \item{\code{clust2}}{A vector of group indices for each cell.}
  \item{\code{clust_dat}}{A matrix used as input for hierarchical clustering.}
}
}
\description{
This function returns a list with elements mainly generated from sigclust2.
}
\details{
This is a function used to calculate the significance level of the first split from hierarchical clustering
based on euclidean distance and Ward's linkage.
}
\references{
\insertRef{kimes2017statistical}{scpoisson}
\insertRef{Rclusterpp}{scpoisson}
}
