% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/season-package.R
\docType{data}
\name{CVDdaily}
\alias{CVDdaily}
\title{Daily Cardiovascular Deaths in Los Angeles, 1987--2000}
\format{
A data frame with 5114 observations on the following 16 variables.
\describe{ \item{date}{date of death in date format
(year-month-day)} \item{cvd}{daily number of CVD deaths}
\item{dow}{day of the week (character)} \item{tmpd}{daily
mean temperature (degrees Fahrenheit)} \item{o3mean}{daily mean
ozone (parts per billion)} \item{o3tmean}{daily trimmed mean ozone
(parts per billion)} \item{Mon}{indicator variable for Monday}
\item{Tue}{indicator variable for Tuesday}
\item{Wed}{indicator variable for Wednesday}
\item{Thu}{indicator variable for Thursday}
\item{Fri}{indicator variable for Friday}
\item{Sat}{indicator variable for Saturday}
\item{month}{month (integer from 1 to 12)}
\item{winter}{indicator variable for winter}
\item{spring}{indicator variable for spring}
\item{summer}{indicator variable for summer}
\item{autumn}{indicator variable for autumn} }
}
\source{
From the NMMAPS study.
}
\usage{
CVDdaily
}
\description{
Daily number of deaths from cardiovascular disease in people aged 75 and
over in Los Angeles for the years 1987 to 2000.
}
\examples{
\donttest{
data(CVDdaily)
plot(CVDdaily$date, CVDdaily$cvd, type='p', xlab='Date',
     ylab='Number of CVD deaths')
}
}
\references{
Samet JM, Dominici F, Zeger SL, Schwartz J, Dockery DW (2000).
\emph{The National Morbidity, Mortality, and Air Pollution Study, Part I:
Methods and Methodologic Issues}. Research Report 94, Health Effects
Institute, Cambridge MA.
}
\keyword{datasets}
