#' @title Seasonal Index for Given Univariate Time Series
#' @param data Univariate Time Series Data
#' @param sl seasonal frequency
#' @import seastests
#' @return error
#' @export
#' @examples {
#' library("seasonalytics")
#' data<- as.ts(rnorm(48,100,48))
#' sl<- 12
#' Result <- SI(data, sl)
#' }
SI <- function(data, sl) {
  n <- length(data)
  groups <- ceiling(seq_along(data) / sl)
  group_avg <- tapply(data, groups, mean, na.rm = TRUE)
  adjusted <- data / rep(group_avg, each = sl)[seq_len(n)]
  season_index <- rep(1:sl, length.out = n)
  seasonal_indices <- tapply(adjusted, season_index, mean, na.rm = TRUE)
  seasonal_indices <- seasonal_indices / mean(seasonal_indices, na.rm = TRUE)
  season_labels <- paste0("S", 1:sl)

  si <- data.frame(
    Season = season_labels,
    Seasonal_Index = as.numeric(round(seasonal_indices, 3))
  )

  return(si)
}
