% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.parameters_model.R,
%   R/plot.parameters_sem.R
\name{plot.see_parameters_model}
\alias{plot.see_parameters_model}
\alias{plot.see_parameters_sem}
\title{Plot method for model parameters}
\usage{
\method{plot}{see_parameters_model}(
  x,
  show_intercept = FALSE,
  size_point = 0.8,
  size_text = NA,
  sort = NULL,
  n_columns = NULL,
  type = c("forest", "funnel"),
  weight_points = TRUE,
  show_labels = FALSE,
  show_estimate = TRUE,
  show_interval = TRUE,
  show_density = FALSE,
  show_direction = TRUE,
  log_scale = FALSE,
  ...
)

\method{plot}{see_parameters_sem}(
  x,
  data = NULL,
  component = c("regression", "correlation", "loading"),
  type = component,
  threshold_coefficient = NULL,
  threshold_p = NULL,
  ci = TRUE,
  size_point = 22,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the
intercept-parameter has a posterior distribution on a very different
location, so density curves of posterior distributions for other parameters
are hardly visible.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{size_text}{Numeric value specifying size of text labels.}

\item{sort}{The behavior of this argument depends on the plotting contexts.
\itemize{
\item \emph{Plotting model parameters}:
If \code{NULL}, coefficients are plotted in the order as they appear in the
summary. Setting \code{sort = "ascending"} or \code{sort = "descending"} sorts
coefficients in ascending or descending order, respectively.
Setting \code{sort = TRUE} is the same as \code{sort = "ascending"}.
\item \emph{Plotting Bayes factors}:
Sort pie-slices by posterior probability (descending)?
}}

\item{n_columns}{For models with multiple components (like fixed and random,
count and zero-inflated), defines the number of columns for the
panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{type}{Character indicating the type of plot. Only applies for model
parameters from meta-analysis objects (e.g. \pkg{metafor}).}

\item{weight_points}{Logical. If \code{TRUE}, for meta-analysis objects, point
size will be adjusted according to the study-weights.}

\item{show_labels}{Logical. If \code{TRUE}, text labels are displayed.}

\item{show_estimate}{Should the point estimate of each parameter be shown?
(default: \code{TRUE})}

\item{show_interval}{Should the compatibility interval(s) of each parameter
be shown? (default: \code{TRUE})}

\item{show_density}{Should the compatibility density (i.e., posterior,
bootstrap, or confidence density) of each parameter be shown?
(default: \code{FALSE})}

\item{show_direction}{Should the "direction" of coefficients (e.g., positive
or negative coefficients) be highlighted using different colors?
(default: \code{TRUE})}

\item{log_scale}{Should exponentiated coefficients (e.g., odds-ratios) be
plotted on a log scale? (default: \code{FALSE})}

\item{...}{Arguments passed to or from other methods.}

\item{data}{The original data used to create this object. Can be a
statistical model.}

\item{component}{Character indicating which component of the model should be
plotted.}

\item{threshold_coefficient}{Numeric, threshold at which value coefficients will be displayed.}

\item{threshold_p}{Numeric, threshold at which value p-values will be displayed.}

\item{ci}{Logical, whether confidence intervals should be added to the plot.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::model_parameters()} function.
}
\note{
By default, coefficients and their confidence intervals are colored
depending on whether they show a "positive" or "negative" association with
the outcome. E.g., in case of linear models, colors simply distinguish positive
or negative coefficients. For logistic regression models that are shown on the
odds ratio scale, colors distinguish odds ratios above or below 1. Use
\code{show_direction = FALSE} to disable this feature and only show a one-colored
forest plot.
}
\examples{
library(parameters)
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
result <- model_parameters(m)
result
plot(result)
}
