% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higher_freq.R
\name{drbounds}
\alias{drbounds}
\title{Upper bounds on double reduction rates.}
\usage{
drbounds(ploidy, model = c("ces", "prcs"))
}
\arguments{
\item{ploidy}{The ploidy}

\item{model}{Either complete equational segregation (\code{"ces"}) (Mather, 1935)
or pure random chromatid segregation \code{"prcs"})  (Haldane, 1930). See also
Huang et al. (2019).}
}
\value{
A vector of length \code{floor(ploidy / 4)} containing the upper bounds
on the rates of double reduction. The \code{i}the element is the
upper bound on the probability that there are \code{i} pairs of
identical by double reduction alleles in a gamete.
}
\description{
Provides the upper bounds on the double reduction rates based on the
formulas in Huang et al. (2019). There are two upper bounds provided.
The upper bound from complete equational separation is higher than
the upper bound from the pure random chromatid segregation.
}
\examples{
drbounds(4)
drbounds(6)
drbounds(8)
drbounds(10)

}
\references{
\itemize{
\item{Haldane, J. B. S. (1930). Theoretical genetics of autopolyploids. \emph{Journal of genetics}, 22, 359-372. \doi{10.1007/BF02984197}}
\item{Huang, K., Wang, T., Dunn, D. W., Zhang, P., Cao, X., Liu, R., & Li, B. (2019). Genotypic frequencies at equilibrium for polysomic inheritance under double-reduction. \emph{G3: Genes, Genomes, Genetics}, 9(5), 1693-1706. \doi{10.1534/g3.119.400132}}
\item{Mather, K. (1935). Reductional and equational separation of the chromosomes in bivalents and multivalents. \emph{Journal of genetics}, 30, 53-78. \doi{10.1007/BF02982205}}
}
}
\author{
David Gerard
}
