% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_edge_label_positions.R
\name{safe_edge_label_position}
\alias{safe_edge_label_position}
\title{Adjust Edge Label Positions to
Avoid Overlapping Labels}
\usage{
safe_edge_label_position(
  object,
  layout = NULL,
  default_pos = 0.5,
  tolerance = 0.05,
  update_plot = TRUE
)
}
\arguments{
\item{object}{It can be the output of
\code{\link[lavaan:sem]{lavaan::sem()}} or
\code{\link[lavaan:lavaan]{lavaan::lavaan()}}, or a
\code{lavaan}-class object. The model must
have a \code{beta} matrix of the
structural path. It can also be a
\code{qgraph} object generated by
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}.}

\item{layout}{A layout matrix.
Required if \code{object} is a
\code{lavaan}-class object. Ignored if
\code{object} is a \code{qgraph} object.}

\item{default_pos}{Used if \code{object}
is a \code{lavaan}-class object. The
default position of an edge label.
If this position is "safe" (not
on the intersection between paths),
it will be used. Ignored if \code{ object} is a \code{qgraph} object.}

\item{tolerance}{If the distance
between a position and an intersection
is greater than this distance, then
a position is considered safe and
will not be adjusted.}

\item{update_plot}{Logical. Used on
if \code{object} is a \code{qgraph} object. If
\code{TRUE}, the function returns a
modified \code{qgraph} object. If \code{FALSE},
the function returns a named vector
of the new positions.}
}
\value{
If \code{object} is a \code{lavaan}-class
object, it returns
a named numeric vector of edge
positions to be used by
\code{\link[=set_edge_label_position]{set_edge_label_position()}}.
If \code{object} is a \code{qgraph} object
and \code{update_plot} is \code{TRUE}, it
returns a \code{qgraph} object with the
adjusted edge label positions.
Otherwise, it returns a named vector
of the position to be adjusted, as
for a \code{lavaan}-class object.
}
\description{
Move the edge labels
away from path intersections.
}
\details{
This function identify all intersection
points between two paths in a model,
and set the position of an edge
label to the mid-point of a line segment
between an intersection point and
the another intersection point or
the origin/destination of a path.

This function is intended for having
a "likely" readable graph with as
little user-intervention as possible.
If precise control of the edge label
positions is desired, use
\code{\link[=set_edge_label_position]{set_edge_label_position()}}.
}
\examples{

library(lavaan)
library(semPlot)
# Create a dummy dataset
mod_pa <-
"
m11 ~ c1 + x1
m12 ~ c2 + m11 + m21
m21 ~ c1 + x1
m22 ~ c1 + m21 + m11
y ~ m12 + m22 + x1
"
fit <- lavaan::sem(
          mod_pa,
          do.fit = FALSE
        )
dat <- simulateData(
          parameterTable(fit),
          sample.nobs = 500,
          seed = 1234
        )
fit <- lavaan::sem(
          mod_pa,
          dat
        )
# Set the layout
m <- auto_layout_mediation(
        fit,
        exclude = c("c1", "c2", "c3")
      )
pos_new <- safe_edge_label_position(
                fit,
                layout = m
              )
pos_new
pm <- semPlotModel(fit) |> drop_nodes(c("c1", "c2"))
p <- semPaths(
          pm,
          whatLabels = "est",
          layout = m,
          DoNotPlot = TRUE
        )
# Three labels overlap with each other
plot(p)
# Update the plot
p_safe <- p |> safe_edge_label_position()
# Three labels do not overlap in this plot
plot(p_safe)
# Set the position manually
p_safe2 <- p |>
            set_edge_label_position(pos_new)
plot(p_safe2)


}
\seealso{
\code{\link[=set_edge_label_position]{set_edge_label_position()}}
on setting the positions of edge
labels.
}
