% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_lhsOpt.R
\name{calculate_lhsOpt}
\alias{calculate_lhsOpt}
\title{Analyze optimal Latin hypercube sample number}
\usage{
calculate_lhsOpt(
  mats,
  PCA = TRUE,
  quant = TRUE,
  KLdiv = TRUE,
  minSamp = 10,
  maxSamp = 100,
  step = 10,
  rep = 10,
  iter = 10000
)
}
\arguments{
\item{mats}{List. Output from \code{\link{calculate_pop}} function.}

\item{PCA}{Logical. Calculates principal component loadings of the population for PCA similarity factor testing.
\code{default = FALSE}.}

\item{quant}{Logical. Perform quantile comparison testing.}

\item{KLdiv}{Logical. Perform Kullback–Leibler divergence testing.}

\item{minSamp}{Numeric. Minimum sample size to test. \code{default = 10}.}

\item{maxSamp}{Numeric. Maximum sample size to test. \code{default = 100}.}

\item{step}{Numeric. Sample step size for each iteration. \code{default = 10}.}

\item{rep}{Numeric. Internal repetitions for each sample size. \code{default = 10}.}

\item{iter}{Positive Numeric. The number of iterations for the Metropolis-Hastings
annealing process. Defaults to \code{10000}. Internal to \code{\link[clhs]{clhs}}.}
}
\value{
data.frame with summary statistics.
}
\description{
Population level analysis of metric raster data to determine optimal Latin Hypercube sample size
}
\note{
Special thanks to Dr. Brendan Malone for the original implementation of this algorithm.
}
\examples{
\dontrun{
#--- Load raster and access files ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

#--- calculate lhsPop details ---#
mats <- calculate_pop(mraster = mr)

calculate_lhsOpt(mats = mats)

calculate_lhsOpt(
  mats = mats,
  PCA = FALSE,
  iter = 200
)
}

}
\references{
Malone BP, Minasny B, Brungard C. 2019. Some methods to improve the utility of conditioned Latin hypercube sampling. PeerJ 7:e6451 DOI 10.7717/peerj.6451
}
\author{
Tristan R.H. Goodbody
}
\concept{analyze functions}
