% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-existing.R
\name{check_existing}
\alias{check_existing}
\title{Check existing sample data against requirements}
\usage{
check_existing(existing, raster, nSamp, plot = FALSE, details = NULL)
}
\arguments{
\item{existing}{sf 'POINT'.  Existing plot network.}

\item{raster}{SpatRaster. Raster to guide the location of the samples. If \code{type = "clhs"} this raster can also
be used to define the population distributions to be used for sampling.}

\item{nSamp}{Numeric. Number of desired samples.}

\item{details}{Logical. If \code{FALSE} (default) output is sf object of
systematic samples. If \code{TRUE} returns a list of sf objects where \code{tessellation}
is the tessellation grid for sampling, and \code{samples} are the systematic samples.}
}
\value{
If requirements are met, the function returns the prepared existing sample data.
Otherwise, it raises a stop error with a relevant message.
}
\description{
This function checks whether the existing sample data meets certain requirements for use in downstream analyses.
}
\keyword{internal}
