% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vctrs.R
\name{skimr-vctrs}
\alias{skimr-vctrs}
\alias{vec_ptype2.skim_df.skim_df}
\alias{vec_ptype2.skim_df.tbl_df}
\alias{vec_ptype2.tbl_df.skim_df}
\alias{vec_cast.skim_df.skim_df}
\alias{vec_cast.skim_df.tbl_df}
\alias{vec_cast.tbl_df.skim_df}
\title{Functions for working with the vctrs package}
\usage{
\method{vec_ptype2}{skim_df.skim_df}(x, y, ...)

\method{vec_ptype2}{skim_df.tbl_df}(x, y, ...)

\method{vec_ptype2}{tbl_df.skim_df}(x, y, ...)

\method{vec_cast}{skim_df.skim_df}(x, to, ...)

\method{vec_cast}{skim_df.tbl_df}(x, to, ...)

\method{vec_cast}{tbl_df.skim_df}(x, to, ...)
}
\description{
These make it clear that we need to use the tibble behavior when joining,
concatenating or casting \code{skim_df} objects. For a better discussion, on
why this is important and how these functions work, see:
\url{https://vctrs.r-lib.org/reference/howto-faq-coercion-data-frame.html}.
}
\details{
\verb{vec_ptype2.*} handles finding common prototypes between \code{skim_df} and
similar objects. \verb{vec_cast.*} handles casting between objects. Note that
as of \verb{dplyr 1.0.2}, \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}} does not full support combining
attributes and \code{\link[vctrs:vec_bind]{vctrs::vec_rbind()}} is preferred instead.
}
\keyword{internal}
